/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.Identifiable;
import com.aptana.core.util.ClassUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageAssociations {
    private static final String TAG_OBJECT_IMAGE = "objectImage";
    private static final String TAG_IMAGE = "image";
    private static final String ATT_ID = "id";
    private static final String ATT_OBJECT_CLASS = "objectClass";
    private static final String ATT_ICON = "icon";
    private static final String EXTENSION_POINT_ID = "imageAssociations";
    private static ImageAssociations instance;
    private Map<String, ImageDescriptor> idToImageMap = new HashMap<String, ImageDescriptor>();
    private Map<String, ImageDescriptor> classNameToImageMap = new HashMap<String, ImageDescriptor>();
    private Map<Class<?>, ImageDescriptor> classToImageMap = new HashMap();

    private ImageAssociations() {
        this.readExtensionRegistry();
    }

    public static ImageAssociations getInstance() {
        if (instance == null) {
            instance = new ImageAssociations();
        }
        return instance;
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.ui", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                ImageAssociations.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newInOrderSet((Object[])new String[]{ImageAssociations.TAG_IMAGE, ImageAssociations.TAG_OBJECT_IMAGE});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_IMAGE.equals(element.getName())) {
            String id = element.getAttribute(ATT_ID);
            if (id == null || id.length() == 0) {
                return;
            }
            String icon = element.getAttribute(ATT_ICON);
            if (icon == null || icon.length() == 0) {
                return;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)icon);
            if (imageDescriptor == null) {
                return;
            }
            this.idToImageMap.put(id, imageDescriptor);
        } else if (TAG_OBJECT_IMAGE.equals(element.getName())) {
            String clazz = element.getAttribute(ATT_OBJECT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            String icon = element.getAttribute(ATT_ICON);
            if (icon == null || icon.length() == 0) {
                return;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)icon);
            if (imageDescriptor == null) {
                return;
            }
            this.classNameToImageMap.put(clazz, imageDescriptor);
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.idToImageMap.get(id);
    }

    public ImageDescriptor getImageDescriptor(Class<?> clazz) {
        ImageDescriptor imageDescriptor = this.classToImageMap.get(clazz);
        if (imageDescriptor == null && !this.classToImageMap.containsKey(clazz)) {
            for (Class i : ClassUtil.getClassesTree(clazz)) {
                imageDescriptor = this.classToImageMap.get(i);
                if (imageDescriptor == null) {
                    imageDescriptor = this.classNameToImageMap.get(i.getName());
                }
                if (imageDescriptor != null) break;
            }
            this.classToImageMap.put(clazz, imageDescriptor);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor imageDescriptor;
        if (element == null) {
            return null;
        }
        if (element instanceof Identifiable && (imageDescriptor = this.getImageDescriptor(((Identifiable)element).getId())) != null) {
            return imageDescriptor;
        }
        return this.getImageDescriptor(element.getClass());
    }
}

